﻿var AgentAssignment = {
    userid: 0,
    m_iWorkingProntoMdouleId: 0,
    m_iCurrentProntoModuleId: 0,
    m_bCurrentCatiOnly: false ,
    m_iCurrentCatiModuleId:0,
    m_iInboundCatiId: 0 ,
    m_bAssignmentEnable: true,
    m_bNewAssignment: false,
    m_bSwitchProjectInProcess: false,
    m_bCatiSwitchOnInterviewComplete: false,
    m_CatiProperties: [],
    callback: { onCatiSwitchProject: null, onExecuteProntoCmd: null, onCatiOnlySetDisplay: null},
    project: {
        m_iUserId: 0,
        m_szAgentName: "",
        m_szSessionGuid: "",
        m_bAssignmentFeatureEnable: false,
        m_bCatiOnly: false,
        m_iProntoServerId: 0,
        m_iProntoModuleId: 0,
        m_iCatiModuleId: 0,
        m_bProntoReassigned: false,
        m_bCatiReassigned: false,
        m_szCatiName: "",
        m_szProntoName: "",
        m_bCatiRedirect: false,
        m_szRedirectUrl: "",
        m_bForceSignoff: false,
        m_bTelephonyServerReassigned: false,
        m_iProntoModuleType: 0,
        m_iBlendAssociatedModuleType: 0,
        m_bCanSwitchProject: true,
        m_szDialog: "",
        m_szProjectName: "",
        m_iProntoCallDelay: 0,
        m_bLastCall: true,
        m_bAutomaticPreview: false,
        m_bProjectSignonSuccess: true,
        m_szPreviousSessionGuid: "",
        m_szPreviousIntwebUrl: "",
        m_iWorkflowModuleCount:0 ,
        m_CatiProperties: {}
    },

    
    init: function (_callback) {
        if (typeof _callback.onExecuteProntoCmd == "function")
            this.callback.onExecuteProntoCmd = _callback.onExecuteProntoCmd;

        if (typeof _callback.onCatiSwitchProject == "function")
            this.callback.onCatiSwitchProject = _callback.onCatiSwitchProject;

        if (typeof _callback.onCatiOnlySetDisplay == "function")
            this.callback.onCatiOnlySetDisplay = _callback.onCatiOnlySetDisplay;

        //
        // Pas certain que ca soit necessaire. A valide en passant de cati a pronto et de pronto a cati
        // Permet de mettre le button last call sans le check pour indiquer
        // que nous sommes en last call
        //
        gClassManager.getButtonClass().Set("btnLastCall", false);
        return;
    },

    // Vxd_PageState
    //  Vxd_PageType
    //
    //  AgentAssignment.SetSessionManagementProject
    //
    //      Pour garder la compatiblite avec le sessuon management de Pronto      
    //

    SetSessionManagementProject: function (_prontoModuleId) {

        var bSessionManagementSwitch = false ;

        try {
            if (typeof _prontoModuleId == "string" && _prontoModuleId.length != 0 && _prontoModuleId != this.m_iCurrentProntoModuleId) {

                var iModuleid = parseInt(_prontoModuleId);
                if( iModuleid == 0 )
                    return  false ;

                this.project.m_iProntoModuleId = iModuleid;

                var assignment;
                var additionnalSetting = {};
                additionnalSetting.async = false;

                //
                //  Avec le session management , l'agent choisit plusieurs projets a la fois avec la grille de 
                //  selection de projets
                //
                //  GetSessionManagementCatiAssignment -> permet d'ajuster le projet cati en fonction de la 
                //  multiple selections
                //
                iCommon.callServerMethod("CloseSentinel.aspx", "GetSessionManagementCatiAssignment", { Assignment: this.project }, function (result) { if (result.d != null) assignment = result.d; }, function (xhr, msg, e) { }, additionnalSetting);
                if (typeof assignment == "object") {
                    this.project = assignment;
                    bSessionManagementSwitch = true;
                }
            }
        }
        catch (e) {
            this._error("SetSessionManagementProject> caugth a java script error when getting session management specification... exception: ", e.message);
        }

        return bSessionManagementSwitch;
    },


    //
    //  AgentAssignment.EnableAssignment
    //
    //    Actif pour les projets :
    //  
    //      - Preview
    //      - Automatic
    //      - Blend 
    //      - Cati seulement .
    //      
    //

    EnableAssignment: function () {
        ConsoleDebug._info("AgentAssignment.DisableAssignment> The assignment is now enable .");
        this.m_bAssignmentEnable = true;
    },

    //
    //  AgentAssignment.DisableAssigment
    //
    //      Desactiver dans lorsque les agents executent un callback ou dans les cas review.
    //

    DisableAssignment: function () {
        ConsoleDebug._info("AgentAssignment.DisableAssignment> The assignment is now disable.");
        this.m_bAssignmentEnable = false;
    },


    getCallDelay:function()
    {
        return this.project.m_iProntoCallDelay;
    },

    isProjectButtonRequired: function () {
        return this.m_bCanSwitchProject;
    },

    isManualDialingProject: function(){
        var bManual = false;
        if (this.project.m_iProntoModuleType == _MODULE_MANUALDIALING || this.project.m_iBlendAssociatedModuleType == _MODULE_MANUALDIALING) {
            bManual = true;
        }

        return bManual;
    },
   
    isBlendProjectWithAssociated: function () {

        var result = false;
        if (this.isBlendProject() == true && this.getProntoModuleId() != 0 ) {
            result = true;
        }

        return result;
    },

    isCatiOnly: function(){
        return this.m_bCurrentCatiOnly;
    },

    isBlendProject: function () {

        var bBlend = false;
        if (this.project.m_iProntoModuleType == _MODULE_BLEND) {
            bBlend = true ;
        }

        return bBlend;
    },

    SetWorkingModuleId: function(WorkingProntoModuleId, ProntoModuleName ){

        if (typeof WorkingProntoModuleId == "number")
            this.project.m_iProntoModuleId  = WorkingProntoModuleId;

        if( typeof ProntoModuleName == "string")
            this.project.m_szProntoName  = ProntoModuleName;

        return;
    },

    getSessionGuid: function()
    {
        return this.project.m_szSessionGuid ;
    },

    getAgentName: function()
    {
        return this.project.m_szAgentName ;
    },

    getCurrentCatiModuleId: function(){
        return this.m_iCurrentCatiModuleId;
    },

  
    getProntoModuleId: function()
    {
        return this.project.m_iProntoModuleId;
    },


    getUserId: function () {
        return this.project.m_iUserId;
    },



    getWorkingModuleId: function()
    {
        return this.project.m_iProntoModuleId;
    },

    getModuleName: function()
    {
        var modulename="" ;
        if( this.m_bCurrentCatiOnly == true )
            modulename = this.project.m_szCatiName ;
        else
            modulename = this.project.m_szProntoName ;

        return modulename ;
    },

    getProntoModuleName: function()
    {
        return this.project.m_szProntoName ;
    },

    getCatiId: function()
    {
        return this.project.m_iCatiModuleId ;
    },

    GetInboundCatiId: function()
    {
        return this.m_iInboundCatiId ;
    },

    SetInboundCatiProperties: function( catiModuleId )
    {
        this.m_iInboundCatiId = catiModuleId;

        /*
        if (SessionTimeout.isEnable() == false)
            return;
         */
        var catiProperties = this.GetCatiProperties(catiModuleId);
        if (typeof catiProperties != "object" || catiProperties == null)
            return;


        //
        //  Avec un module blend , le module cati appartient a la file ACD donc le module est connu qu'a la reception d'appel .
        //  La methode StartInboundSessionTimeout permet de sauvegarder la valeur precedente du timeout pour le module associe
        //  et ramener la valeur du timeout avec la methode SessionTimeout.RestoreSessionTimeout
        //
        this._info("Setting inbound call session timeout to " + catiProperties.m_CatiSessionMSTimeout + " ms" );
        SessionTimeout.StartInboundSessionTimeout(catiProperties.m_CatiSessionMSTimeout);
        return ;
    },

    isAutomaticProject: function()
    {
        var bAutomatic = true ;
        switch(  this.project.m_iProntoModuleType )
        {
            case _MODULE_MANUALDIALING:
            case _MODULE_HYBRID:
            case _MODULE_BLEND:
            case _MODULE_EXPERT:
            case _MODULE_NONPRED:
            case _MODULE_PRED:
                break;
            case _MODULE_PREVIEW:
            case _MODULE_UNDEF:
            default:
                bAutomatic = false ;
                break;
        }

        return bAutomatic; 
    },
    
    isProjectType: function( ProntoModuleType )
    {
        var bProjectType = false;
        try {
            if (this.project.m_iProntoModuleType == ProntoModuleType)
                bProjectType = true;

        }
        catch (e) {
            this._error("isProjectType> caugth a java script exception -- " + e.message + ". Returning -> " + bProjectType);
        }

        return bProjectType;

    },

    getProjectType: function()
    {
        return this.project.m_iProntoModuleType;
    },

    //
    //  Changement de module pronto sur un meme serveur telephonique
    //
    onCatiSwitchProject:function()
    {

        //
        //  this.project.m_bProntoReassigned == false --  pas de changement de Pronto
        //  this.project.m_bCatiReassigned  == false   --  pas de changement de cati
        //  
        //  Dans ces conditions aucun switch 
        //

        if (this.project.m_bProntoReassigned == false && this.project.m_bCatiReassigned == false )
            return;

        
        //
        //  On laisse un delai de 500ms pour laisser le temps a Intweb de digerer le Close du Projet
        //

        setTimeout( 
            function()
            {
                var sharedFrame = gClassManager.getSharedFrame();
                sharedFrame.location = AgentAssignment.project.m_CatiProperties.m_szIntwebGetUrl;
                AgentAssignment.DifferedWait();
            }
            , 500
        )

        this.Reset();
        return;
    },

    isAutomaticPreviewCallEnable: function ()
    {
        if (this.project.m_bAutomaticPreview == false || this.m_bCurrentCatiOnly == true )
            return false;

        if (this.isAutomaticProject() == true)
            return false;

        return true ;
    },

    isAutomaticPreviewCall: function () {

        var bAutomaticPreviewCall = true ;
        if (this.isAutomaticPreviewCallEnable() == false || this.project.m_iProntoCallDelay == 0 || ICRequest.isLastCall() == true)
            bAutomaticPreviewCall = false ;

        return bAutomaticPreviewCall ;
    },
    //
    //  On garde en cache les cati des agents surtout utile pour les projets Blend avec les
    //  appels entrant et sortant. Pour les appels entrants , nous connaissons le cati qu'a
    //  l'arriver l'appel. Pour le premier appel, nous allons chercher les caracteristiques de 
    //  l'appel et nous la gardons en cache pour eviter de faire une requete WEB.
    //
    GetCatiProperties: function( catiModuleId )
    {
        if( ( typeof catiModuleId != "string" && typeof catiModuleId != "number" ) || catiModuleId == 0)
            return this.project.m_CatiProperties ;

        if( typeof this.m_CatiProperties[catiModuleId] == "object" )
            return this.m_CatiProperties[catiModuleId] ;

        var assignment;
        var additionnalSetting = {};
        additionnalSetting.async = false;

        //
        //  Nous ne connaissons pas le cati , allons chercher ces caracteristiques 
        //
        var catiProperties = null;
        iCommon.callServerMethod("CloseSentinel.aspx", "getCatiBaseUrl", { catiId: catiModuleId }, function (result) { if (result.d != null) catiProperties = result.d; }, function (xhr, msg, e) { }, additionnalSetting);
        if (typeof catiProperties != "object" || catiProperties == null ) {
            return null;
        }


        if (catiProperties != null && catiProperties.m_CatiUrl != null) {

            var voxcoAgent = new Url(catiProperties.m_BrowserBaseUrl);
            var cati = new Url(catiProperties.m_CatiUrl);
   
            CrossDomainInfo.m_bCrossDomain = CrossDomainInfo.VerifyCrossDomain(catiProperties.m_CatiUrl);
            if (CrossDomainInfo.m_bCrossDomain == true) {
                catiProperties.m_bCrossDomain       = true;            
                CrossDomainInfo.m_szAgentId         = AgentAssignment.getUserId();
                CrossDomainInfo.m_szProjectName     = AgentAssignment.getProntoModuleName();
                CrossDomainInfo.m_szVoxcoAgentUrl   = voxcoAgent.Get();
                CrossDomainInfo.m_szIntwebUrl       = cati.Get();
                CrossDomainInfo.m_szModuleId        = AgentAssignment.getProntoModuleId();
                CrossDomainInfo.m_szProjectype      = AgentAssignment.getProjectType();
                CrossDomainInfo.m_szMessage         = getTranslatedString("STR_CROSSDOMAIN_POLICY");
            }
        }
        

        //
        // on le garde en cache pour la vie de la session de l'agent
        //
        this.m_CatiProperties[catiModuleId] = catiProperties;
        return catiProperties;
    },



    //
    //  AgentAssignment.setModuleName --  Affichage du nom du module a au header de voxco.agent
    //

    setModuleName: function( modulename )
    {
        var _name = this.getModuleName();
        if (typeof modulename == "string")
            _name = modulename;

        try {
            var topHeader = gClassManager.getHeaderFrame();
            var _txtobj = topHeader.document.getElementById('prontoModuleNameTxt');
            if (_txtobj != undefined) {
                _txtobj.innerHTML = _name;
                _txtobj.title = _name;
            }
        }
        catch (e) {
            error("setProntoProjectName> not able to set project module name -- raison: " + e.message);
        }
    },

    //
    //  AgentAssignment.GetProjectAssignment
    //
    //  Nous allons chercher les cateristiques du project c'est a dire:
    //      catimoduleid 
    //      prontomoduleid
    //      nom du module cati
    //      nom du module pronto
    //      redirect ou pas redirect d'un cati A vers un cati B
    //      les url du cati 
    //
    //
    //  Cette methode doit etre appele qu'une seule fois durant la session de l'agent a cause
    //  de l'appel de la fonction AgentAssignment.DifferedWait(). Elle declenche un wait automatique
    //

    GetProjectAssignment: function()
    {

        if (this.m_bSwitchProjectInProcess == true)
        {
            this._debug("No need to get project assignment ... we are switching project");
            return true ;
        }
          
        var assignment;
        var additionnalSetting = {};
        additionnalSetting.async = false;

        iCommon.callServerMethod("CloseSentinel.aspx", "GetProjectAssignment", { Project: this.project }, function (result) { if (result.d != null) assignment = result.d; }, function (xhr, msg, e) { }, additionnalSetting);
        if (typeof assignment != "object") {
            return false;
        }
        
        //
        //  m_iCurrentProntoModuleId -> le module de travaille de l'agent . Utilse dans la logique
        //  des assignations de projet en ce qui concerne la compatibilite avec le session management
        //
        this.project = assignment;
        this.m_CatiProperties[0] = assignment.m_CatiBaseUrl ;
        this.m_CatiProperties[assignment.m_iCatiModuleId] = assignment.m_CatiProperties;
        this.m_iCurrentProntoModuleId = this.project.m_iProntoModuleId;
        this.m_iCurrentCatiModuleId = this.project.m_iCatiModuleId;
        this.m_bCurrentCatiOnly = this.project.m_bCatiOnly;


        this._info("Setting module " + this.getModuleName() +  " call session timeout to " + assignment.m_CatiProperties.m_CatiSessionMSTimeout + " ms");
        SessionTimeout.Start(assignment.m_CatiProperties.m_CatiSessionMSTimeout);

        if (this.project.m_szPreviousSessionGuid != this.project.m_szSessionGuid)
            IntWeb.ClosePreviousSession(this.project.m_szPreviousIntwebUrl, this.project.m_szPreviousSessionGuid);

        //
        //  ICRequest.setLastCall on s'assure que la logique du code suive.. 
        //  Beaucoup de code depend de ICRequest.isLastCall ... TODO a modifier 
        //
        ICRequest.setLastCall(this.project.m_bLastCall, "getProjectAssignment");
        AgentAssignment.DifferedWait();
            
        if (this.project.m_bCatiOnly == true )
            this._info("The agent is working on cati project only...");
       
        if (this.project.m_iProntoModuleType == _MODULE_BLEND) {
            this._info("The agent has selected a blend project...");
        }

        this.setModuleName();
        return true;
    },

    //
    // AgentAsignment.CatiSwitchingProject
    //
    //      Utilise lorsque nous passons d'un module cati seulement a un module cati + module Pronto
    //
    CatiSwitchingProject: function()
    {
        if (this.m_bCatiSwitchOnInterviewComplete == true)
        {
            this.m_bCatiSwitchOnInterviewComplete = false;
            IntWeb.Close(this.m_iCurrentCatiModuleId);
            this.switchProject();
        }
    },


    SelectionPageReturn: function( parm,  reason )
    {
        this._info("AgentAssignment.SelectionPageReturn> We are force to return to the page selection because " + reason);

        var page = "SelectProjects.aspx" + parm;
        var shareFrame = gClassManager.getSharedFrame();
        shareFrame.location = page;
    },

    isLastCall: function() 
    {
        //
        //  La verification du last call est premordiale pour l'affichage des status 
        //  a voxco.agent surtout en ce qui concerne le Delay pour le wait automatique.
        //
        //  isAutomaticPreviewCall : L'automatique call preview depend d'un parametre de configuration app.config . si ce
        //  parametre est actif, le status delay et le bouton lastcall sont utilise
        //
        //  isAutomaticProject: projet automatique ( hybride , pred , non-pred ... )
        //
        //  Si les deux sont false , nous forcons le lastcall pour obtenir le status IDLE a voxco.agent
        //
        //
        if (this.isAutomaticPreviewCallEnable() == false && this.isAutomaticProject() == false)
            return true;

        return this.project.m_bLastCall;
    },

    //  AgentAssignment.interviewComplete --  Appeler essentiellement par closesentinel.apx pour compelete l'entrevue

    interviewComplete: function( Parameter )
    {
        // 
        // Si nous sommes en situation de last call , aucune verification
        // pour une nouvelle assignation sauf si nous sommes un projet preview
        // Le projet preview est en lastcall par defaut. Ce n'est pas un
        // projet automatique
        //

        var blastCall = ICRequest.isLastCall();
        if (blastCall == false || this.isProjectType( _MODULE_PREVIEW ) == true)
        {
            //
            //  Si l'agent n'appuie pas sur le bouton lastcall ,  nous verifions si l'agent a change de project.
            //
            var bNewAssignment = AgentAssignment.isNewAgentAssignment();
            if (bNewAssignment == true)
            {
                //
                //  setLastCall == true , indique a la telephonie l'agent effectue son dernier appel pour 
                //  ce projet. Nous evitons ainsi de drop.
                //
                blastCall = true;
            }
        }

        // 
        // Dans un module blend ( inbound/outbound ) restaure le timeout qui appartient au module cati du module associe au module blend
        // Dans le cas d'un module blend sans module pronto associe nous ne faisons rien
        //

        SessionTimeout.RestoreSessionTimeout();
        //
        //  Execution de l'interview complete
        //
        ICRequest.addParameter(Parameter);
        ICRequest.concatParameter("LASTCALL", blastCall == false ? "false" : "true");
        ICRequest.concatParameter("WITHPOLLING","true");
        ICRequest.execute(this.project.m_iProntoModuleType, this.project.m_iUserId );
        return ;
    },

    isProntoServerReassigned: function(){
        return this.project.m_bTelephonyServerReassigned ;
    },
       

    //
    //  Appele si nous avons un mask interview complete avec un project cati seulement ( ExamineIntWenPage() ).
    //  TODO: a un manque d'echantillon en appuyant sur le bouton new call.
    //
    //   On verifie si l'agent a ete assigne a un nouveau projet. en mode cati seulement
    //

    GetNewCatiProjectAssignment: function()
    {
        if (this.isCatiOnly() == false)
            return false ;

        var bNewAssignment = this.isNewAgentAssignment();
        if (bNewAssignment == false)
            return false ;
        
        this.m_bCatiSwitchOnInterviewComplete = true;
        return bNewAssignment
    },


    //
    //  AgentAssignment.GetNewProjectAssignment
    //
    //     Verifie si les agents ont ete assignes a un autre projet
    //

    GetNewProjectAssignment: function () {

        if (this.m_bAssignmentEnable == false)
        {
            ConsoleDebug._debug("AgentAssignment.GetNewProjectAssignment> Assignment is disable. The agent might do callback or he is review case...");
            return false ;
        }
           
        var assignment;
        var additionnalSetting = {};
        additionnalSetting.async = false;

        iCommon.callServerMethod("CloseSentinel.aspx", "GetNewProjetAssignment", { Assignment: this.project }, function (result) { if (result.d != null) assignment = result.d; }, function (xhr, msg, e) { }, additionnalSetting);

        if (typeof assignment != "object") {
            return false;
        }

        this.project = assignment;
        this.setModuleName();

        this._info("Setting module " + this.getModuleName() + " call session timeout to " + assignment.m_CatiProperties.m_CatiSessionMSTimeout + " ms");
        SessionTimeout.Start(assignment.m_CatiProperties.m_CatiSessionMSTimeout);
        return true ;
    },

    isNewAgentAssignment: function()
    {
        if (this.m_bAssignmentEnable == false || this.project.m_bAssignmentFeatureEnable == false ) {
            return false;
        }

        this.GetNewProjectAssignment() ;
        return this.isNewProjectAssigned() ;
    },

    onClose: function (bTimeout) {

        if (typeof bTimeout != "boolean" || bTimeout == false)
            return;


        AgentAssignment.onAssignmentConfirm();
        return;
    },

    onAssignmentConfirm: function()
    {
        if (AgentAssignment.m_bSwitchProjectInProcess == true)
            return;

        //
        //
        // SwitchProjetAssignment: methode ajax qui permet d'effectuer le switch de projet 
        //      - effectue le redirect si redirect il y a 
        //      - effectue un signoff si l'agent avait une session pronto 
        //      - effectue un switch de module pronto si l'agent est sur le module pronto est sur
        //        le meme serveur
        //      - etc
        //

        AgentAssignment.m_bSwitchProjectInProcess = true;

        var additionnalSetting = {};
        additionnalSetting.async = false;

        var SwitchProjectResult;
        AgentAssignment._debug("AgentAssignment.switchProject> calling SwitchProjetAssignment to reassign the agent");
        iCommon.callServerMethod("CloseSentinel.aspx", "SwitchProjetAssignment", { Assignment: AgentAssignment.project }, function (result) { if (result.d != null) SwitchProjectResult = result.d; }, function (xhr, msg, e) { }, additionnalSetting);


        if (typeof SwitchProjectResult != "object")
        {
            AgentAssignment._error("AgentAssignment.switchProject> Not able to switch because SwitchProjetAssignment ajax call failed to return assignment object");
            return;
        }

        //
        //  Fermeture du projet IntWeb
        //
        IntWeb.Close(AgentAssignment.m_iCurrentCatiModuleId);

        AgentAssignment.project = SwitchProjectResult;
        if (AgentAssignment.project.m_bCatiRedirect == true && AgentAssignment.project.m_szRedirectUrl.length > 0) {
            AgentAssignment.showRedirectUrl();
            setTimeout(function () { AgentAssignment.HttpRedirect("assignment.redirect", AgentAssignment.project.m_szRedirectUrl) }, 2000);
            return;
        }

        if (AgentAssignment.project.m_bTelephonyServerReassigned == true)
        {
            AgentAssignment.SelectionPageReturn("", "swiching to a different pronto server -- prontoserver id  " + AgentAssignment.project.m_iProntoServerId);
            IntWeb.forceReload();
            AgentAssignment.Reset();
            return;
        }

        if (AgentAssignment.project.m_bProntoReassigned == true && AgentAssignment.project.m_bProjectSignonSuccess == false)
        {
            AgentAssignment.SelectionPageReturn("", "Project signon failed on: pronto module " + AgentAssignment.project.m_iProntoModuleId + " -- Prontoserver id " + AgentAssignment.project.m_iProntoServerId);
            IntWeb.forceReload();
            AgentAssignment.Reset();
            return;
        }

         
        
        AgentAssignment.onCatiSwitchProject();
        //
        //  Avec un module cati seulement , nous desactivons les boutons non necessaire comme
        //  par exemple : bouton wait , lastcall , hangup etc
        //
   
        if (AgentAssignment.project.m_bCatiOnly == true && typeof AgentAssignment.callback.onCatiOnlySetDisplay == "function")
            AgentAssignment.callback.onCatiOnlySetDisplay();
              
        AgentAssignment.Reset();
        return;
    },

    //
    //  AgentAssignment.setLastCall: L'agent prend son dernier appel
    //
    setLastCall: function( bLastCall, szCallingFunction )
    {
        ICRequest.setLastCall(bLastCall, szCallingFunction);
        this.project.m_bLastCall = bLastCall ;
        return ;
    },

    //
    //  AgentAssignment.swicthOnIntwebNewCall:  En mode preview seulement. Appeler par le bouton newcall de la 
    //                                          page IntWeb
    //

    swicthOnIntwebNewCall: function()
    {
        if (this.project.m_bCatiOnly == false && this.project.m_iProntoModuleType != _MODULE_PREVIEW)
            return;

        //
        //  Sur le premier appel nous ne faison pas de switch de projet 
        //
        if (CallStats.isCallReceived() == false)
            return;
        
        var bNewAssignment = this.isNewAgentAssignment();
        if (bNewAssignment == true) {
            this.switchProject();
        }

        return bNewAssignment;
    },

    //
    //  AgentAssuignment.Wait
    //
    //  L'agent a appuye sur le bouton wait. Nous verifion si l'agent a ete reassigne a un projet  en fonction des 
    //  conditions suivantes:
    //  
    //      1) L'agent a des assignations de projets qui lui sont donnes
    //      2) L'agent a effectue au moins un premier appel.
    //
    Wait: function()
    {
        // 
        //  Si le l'agent execute des callbacks, nous arretons la verification des assignations pour lui permettre 
        //  d'accomplir sa tache. A partir du moment qu'il appuie sur le bouton wait ou newcall pour les appels en
        //  en preview, nous le reativons 
        //

        var bNewAssignment = false;
        this.EnableAssignment();

      

        bNewAssignment = this.isNewAgentAssignment();
        if (bNewAssignment == true) {
            this.switchProject();
            return bNewAssignment;
        }

        this.setLastCall(false, "wait");
        WAITRequest.execute(this.project.m_iUserId);
        return bNewAssignment;
    },

  
    DifferedWait: function()
    {
        //
        //  Si ce n'est pas un project automatique ( pred , hybride , blend ... ) on ne fait pas de wait automatique 
        //

        //
        // project.m_bCatiOnly  == true . Nous n'avons pas de service telephonique . Donc pas besoin de faire de wait
        // this.m_bLastCall == true . L'agent est en lastcall donc pas besion de faire de wait
        // this.project.m_bCatiRedirect == true . Nous  changeons de serveur cati donc pas besoin d'initee la fonction wait 
        // 

        if (this.isAutomaticProject() == false || this.project.m_bLastCall == true || this.project.m_bCatiOnly == true)
            return;

        //
        //  Le DifferedWait est appele par l'interview complete. Lorsque l'interview complete est appele , nous ne voulons
        //  pas demarrer un wait automatique si nous avons une nouvelle assignation. Il est fait plus tard dans le processus
        //  du switch de projet c'est a dire a l'ouverture de sa nouvelle assignation.
        //

        if (this.m_bNewAssignment == true )
            return;
      
        WAITRequest.differedWait(this.project.m_iUserId, ICRequest.getICDelay(1000), "AgentAssignment");
        enableTbButton("btnWait", true);

        var toolbar = gClassManager.getToolbar();
        if (typeof toolbar == "object")
            toolbar.changeStatus(_STATUS_PAUSED);
          
        return ;
    },

    //
    //  AgentAssignment.switchProject
    //
    //     Appele par les commandes :
    //          - Dial en mode proview seulement et par le dialpad 
    //          - Wait 
    //          - Inteview complete
    //


    switchProject: function (bSesssionManagement) {

        //
        //  Pour evite des conflits de dialog , nous arretons le timer du session timeout 
        //  lorsque nous transferons de projets
       
        if ( bSesssionManagement === true) {
            SessionTimeout.StopTimer();
            this._info("AgentAssignment.switchProject> swiching project using session management method...");
            setTimeout(function () { AgentAssignment.onAssignmentConfirm(); }, 5);
            return false;
        }

        if (this.m_bNewAssignment == false) {
            this._debug("AgentAssignment.switchProject> No need to reassign the agent. Nothing change.")
            return false;
        }


        //
        //  Dans le processus de demarrage d'entrevue nous redemarrons le sessiontimeout avec
        //  la methode GetProjectAssignment appele par IntWeb.StartSession()
        //
        SessionTimeout.StopTimer();

        //
        //  Avec le session management pas de presentation de dialog de confirmation
        //

        var dialogtimeout = 10;
        var config = gClassManager.getConfigManager()  ;
        if (typeof config == "object")
            dialogtimeout = config.getAssignmentDialogTimeout();

        var properties = { context:gClassManager.getDialogBoxDocument(), timeout: dialogtimeout, onClose: this.onClose , onClick: this.onAssignmentConfirm };
        DialogBox.showDialog( properties, this.project.m_szDialog );
        return this.m_bNewAssignment;
    },

    //
    // Assignment.StateChange:
    //
    //  Changement d'etat du projet stop / pause   -- peut etre a efface ..
    //
    StateChange: function (status, state, type)
    {
        if (typeof type != "string")
            type = "project"
        
        var statechange = false;
        switch( state.toLowerCase())
        {
            case "stop":
            case "pause":
                this._info("The " + type + " state has change to " + state);
                statechange = true;
                break;

            default:
                break ;

        }
        
        if (statechange == false)
            return;

        var toolbar = gClassManager.getToolbar();
        var message = toolbar.getVAResourceValue('PROJECT-NOT-ACTIVE');
       
        var properties = { context: gClassManager.getDialogBoxDocument()};
        DialogBox.showDialog(properties, message);

        if (this.project.m_bAssignmentFeatureEnable == false)
            return;


        //
        //  on ra
        //
        iCommon.callServerMethod("CloseSentinel.aspx", "RefreshProjetAssignment", { userid: this.project.m_iUserId }, function (result) {}, function (xhr, msg, e) { }, null);
        return;
    } ,

    onProjectSwicthError: function()
    {
        var additionnalSetting = {};
        additionnalSetting.async = false;

        var SwitchProjectResult ;
        iCommon.callServerMethod("CloseSentinel.aspx", "GetNewProjetAssignmentOnProjetStopped", { Assignment: AgentAssignment.project }, function (result) { if (result.d != null) SwitchProjectResult = result.d; }, function (xhr, msg, e) { }, additionnalSetting);

        if (typeof SwitchProjectResult != "object")
            return;

        AgentAssignment.project = SwitchProjectResult;
        if (AgentAssignment.isNewProjectAssigned() == false) {

            //
            // si il n'y a aucun changement de projet nous retournons la page de selection de project
            //
            var properties = {
                context: gClassManager.getDialogBoxDocument(), timeout: 0, onClick: function () { AgentAssignment.SelectionPageReturn("?CancelAutoLogin=1", "no new assignment");}
            };

            var toolbar = gClassManager.getToolbar();
            var message = toolbar.getVAResourceValue('PH_NoNewAssignmentOnError');
            DialogBox.showDialog(properties, message);
            return;
        }
           
        AgentAssignment.switchProject();
        return;
    },

    isNewProjectAssigned: function ()
    {
        this.m_bNewAssignment = false;
        if (this.project.m_bProntoReassigned == true || this.project.m_bCatiReassigned == true || this.project.m_bTelephonyServerReassigned == true ) {
            this.m_bNewAssignment = true;
        }

        return this.m_bNewAssignment;
    },

    //
    //  AgentAssignment.projectSwicthOnWaitError
    //
    //  Lorsque l'agent est en attente d'un appel ou appuye sur le bouton wait il est possible que 
    //  le module pronto soit arrete ou en pause. 
    //
    //  Plusieurs cas 
    //
    //      cas 1 ) L'assignation de projet n'est pas utilise pour cet agent. Voxco.agent ce comporte comme avant .
    //      cas 2 ) L'agent est soumis a l'assignation de project donc nous allons cherche le prochain project disponible dans 
    //              la liste 
    //
    projectSwicthOnWaitError: function (Error) {

        if (this.project.m_bAssignmentFeatureEnable == false ||  typeof Error != "string")
            return false ;


        //
        //  L'agent utilise l'assignation de projet.
        //
        var bSwitchProject = false;
        switch( Error)
        {
            case "PROJECT-NOT-ACTIVE":
            case "PROJECT-CLOSE":
            case "PROJECT-STOP":
                this._info("project is stopped or paused ... starting procedure to get next project assignment");
                bSwitchProject = true;
                setTimeout(this.onProjectSwicthError, 10);
                break
            default:
                break;
        }

        return bSwitchProject;
    },

   
    Reset: function()
    {
        this.project.m_bProntoReassigned = false;
        this.project.m_bCatiReassigned = false;
        this.project.m_bTelephonyServerReassigned = false;
        this.project.m_bForceSignoff = false;
        this.project.m_bCatiRedirect = false;
        this.m_bSwitchProjectInProcess = false;
        this.m_bNewAssignment = false;
        this.project.m_bProjectSignonSuccess = true;

        this.m_iCurrentProntoModuleId = this.project.m_iProntoModuleId;
        this.m_iCurrentCatiModuleId = this.project.m_iCatiModuleId;
        this.m_bCurrentCatiOnly = this.project.m_bCatiOnly;

        CallStats.Reset();
    },

    _debug: function (message) {

        if (typeof Logger != "object")
            return;

        Logger._debug(message);
    },


    _info: function (message) {

        if (typeof Logger != "object")
            return;

        Logger._info(message);
    },


    _error: function( message ) {

        if (typeof Logger != "object")
            return;

        Logger._error(message);
    },
    

    showRedirectUrl: function ( url ) {

        var toolbar = gClassManager.getToolbar();
        if (typeof url == "string" && url.length > 0 ) {
            var shareFrame = gClassManager.getSharedFrame();
            var _txt = shareFrame.document.getElementById('lblErr');
            if (_txt != null) {
                _txt.style.color = 'red';
                _txt.innerHTML = toolbar.getVAResourceValue('STR_REDIRECT') + " " + url ;
            }

            return;
        }

        var message = toolbar.getVAResourceValue('STR_REDIRECT') + " " + this.project.m_CatiProperties.m_CatiUrl;
        var properties = { context: gClassManager.getDialogBoxDocument(), timeout: 2 };
        DialogBox.showDialog(properties, message);
    },

    HttpRedirect: function (Reason, url ) {

    
        var closesentinel = gClassManager.getCloseSentinelFrame();
        closesentinel.reDirecting(true);
        closesentinel.setOnClickCloseSession(true);
        AgentAssignment.Reset();

        var additionnalSetting = {};
        additionnalSetting.async = false;
        iCommon.callServerMethod("CloseSentinel.aspx", "DisposeHttpSession", { szReason: Reason }, function (result) { }, function (xhr, msg, e) { }, additionnalSetting);

        AgentAssignment._info("AgentAssignment.switchProject> The agent has a new assignment but he will be redirect to cati server " + AgentAssignment.project.m_szRedirectUrl);
        top.window.location = url;
    },
}

    